<?php
/**
 * Mark Course
 *
 * @package     AutomatorWP\Integrations\Thrive_Apprentice\Actions\Mark_Course
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Thrive_Apprentice_Mark_Course extends AutomatorWP_Integration_Action {

    public $integration = 'thrive_apprentice';
    public $action = 'thrive_apprentice_mark_course';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Mark course as completed for the user', 'automatorwp-pro' ),
            'select_option'     => __( 'Mark <strong>course as completed</strong> for the user', 'automatorwp-pro' ),
            /* translators: %1$s: Course title. */
            'edit_label'        => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{course}' ),
            /* translators: %1$s: Course title. */
            'log_label'         => sprintf( __( 'Mark %1$s as completed for the user', 'automatorwp-pro' ), '{course}' ),
            'options'           => array(
                'course' => array(
                    'from' => 'course',
                    'default' => __( 'course', 'automatorwp-pro' ),
                    'fields' => array(
                        'course' => automatorwp_utilities_term_field( array(
                            'name'              => __( 'Course:', 'automatorwp-pro' ),
                            'placeholder'       => __( 'Select a course', 'automatorwp-pro' ),
                            'option_none'       => false,
                            'taxonomy' => 'tva_courses',
                            'default' => '',
                        ) ),
                    )
                ),
            ),
        ) );

    }


    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        // Shorthand
        $course_id = absint( $action_options['course'] );
        
        // Bail if not course provided
        if( $course_id === 0 ) {
            return;
        }
        
        $taxonomy = 'tva_courses';
        $term_course = get_term_by('id', $course_id, $taxonomy);

        // To get all lessons from the course
        $course = new TVA_Course_V2( (int) $course_id );
        $lessons_course = $course->get_all_lessons();
        
        // Complete all lessons from the course
        foreach ( $lessons_course as $lesson ){

            $learned = get_user_meta( $user_id, 'tva_learned_lessons', true );

            if ( ! is_array( $learned ) ) {
                $learned = array();
            }

            if ( ! isset( $learned[ $course_id ] ) || ! is_array( $learned[$course_id] ) ) {
                $learned[$course_id] = array();
            }

            // Mark lesson as completed
            $learned[$course_id][$lesson->ID] = 1;

            // Update meta
            update_user_meta( $user_id, 'tva_learned_lessons', $learned );

        }

    }

}

new AutomatorWP_Thrive_Apprentice_Mark_Course();